/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateAuthorizerRequestModelMarshaller {
    private static final MarshallingInfo<String> AUTHORIZERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("authorizerName").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERFUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerFunctionArn").isBinary(false).build();
    private static final MarshallingInfo<String> TOKENKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenKeyName").isBinary(false).build();
    private static final MarshallingInfo<Map> TOKENSIGNINGPUBLICKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenSigningPublicKeys").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final CreateAuthorizerRequestModelMarshaller INSTANCE = new CreateAuthorizerRequestModelMarshaller();

    private CreateAuthorizerRequestModelMarshaller() {
    }

    public static CreateAuthorizerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateAuthorizerRequest createAuthorizerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createAuthorizerRequest), (String)"createAuthorizerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createAuthorizerRequest.authorizerName(), AUTHORIZERNAME_BINDING);
            protocolMarshaller.marshall((Object)createAuthorizerRequest.authorizerFunctionArn(), AUTHORIZERFUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)createAuthorizerRequest.tokenKeyName(), TOKENKEYNAME_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.tokenSigningPublicKeys(), TOKENSIGNINGPUBLICKEYS_BINDING);
            protocolMarshaller.marshall((Object)createAuthorizerRequest.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

