/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CodeSigningSignature;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeSigningSignatureMarshaller {
    private static final MarshallingInfo<SdkBytes> INLINEDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inlineDocument").isBinary(false).build();
    private static final CodeSigningSignatureMarshaller INSTANCE = new CodeSigningSignatureMarshaller();

    private CodeSigningSignatureMarshaller() {
    }

    public static CodeSigningSignatureMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeSigningSignature codeSigningSignature, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeSigningSignature, (String)"codeSigningSignature");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeSigningSignature.inlineDocument(), INLINEDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

