/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CodeSigning;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeSigningMarshaller {
    private static final MarshallingInfo<String> AWSSIGNERJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsSignerJobId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STARTSIGNINGJOBPARAMETER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startSigningJobParameter").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMCODESIGNING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customCodeSigning").isBinary(false).build();
    private static final CodeSigningMarshaller INSTANCE = new CodeSigningMarshaller();

    private CodeSigningMarshaller() {
    }

    public static CodeSigningMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeSigning codeSigning, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeSigning, (String)"codeSigning");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeSigning.awsSignerJobId(), AWSSIGNERJOBID_BINDING);
            protocolMarshaller.marshall((Object)codeSigning.startSigningJobParameter(), STARTSIGNINGJOBPARAMETER_BINDING);
            protocolMarshaller.marshall((Object)codeSigning.customCodeSigning(), CUSTOMCODESIGNING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

