/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeSigningCertificateChainMarshaller {
    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();
    private static final MarshallingInfo<String> INLINEDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inlineDocument").isBinary(false).build();
    private static final CodeSigningCertificateChainMarshaller INSTANCE = new CodeSigningCertificateChainMarshaller();

    private CodeSigningCertificateChainMarshaller() {
    }

    public static CodeSigningCertificateChainMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeSigningCertificateChain codeSigningCertificateChain, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeSigningCertificateChain, (String)"codeSigningCertificateChain");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeSigningCertificateChain.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)codeSigningCertificateChain.inlineDocument(), INLINEDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

