/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CertificateValidity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CertificateValidityMarshaller {
    private static final MarshallingInfo<Instant> NOTBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notBefore").isBinary(false).build();
    private static final MarshallingInfo<Instant> NOTAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notAfter").isBinary(false).build();
    private static final CertificateValidityMarshaller INSTANCE = new CertificateValidityMarshaller();

    private CertificateValidityMarshaller() {
    }

    public static CertificateValidityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CertificateValidity certificateValidity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)certificateValidity, (String)"certificateValidity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)certificateValidity.notBefore(), NOTBEFORE_BINDING);
            protocolMarshaller.marshall((Object)certificateValidity.notAfter(), NOTAFTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

