/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.transform.BehaviorCriteriaUnmarshaller;

public class BehaviorUnmarshaller
implements Unmarshaller<Behavior, JsonUnmarshallerContext> {
    private static final BehaviorUnmarshaller INSTANCE = new BehaviorUnmarshaller();

    public Behavior unmarshall(JsonUnmarshallerContext context) throws Exception {
        Behavior.Builder behaviorBuilder = Behavior.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    behaviorBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("metric", targetDepth)) {
                    context.nextToken();
                    behaviorBuilder.metric((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("criteria", targetDepth)) {
                    context.nextToken();
                    behaviorBuilder.criteria(BehaviorCriteriaUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Behavior)behaviorBuilder.build();
    }

    public static BehaviorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

