/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.BehaviorCriteria;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BehaviorCriteriaMarshaller {
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("comparisonOperator").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATIONSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationSeconds").isBinary(false).build();
    private static final BehaviorCriteriaMarshaller INSTANCE = new BehaviorCriteriaMarshaller();

    private BehaviorCriteriaMarshaller() {
    }

    public static BehaviorCriteriaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BehaviorCriteria behaviorCriteria, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)behaviorCriteria, (String)"behaviorCriteria");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)behaviorCriteria.comparisonOperatorAsString(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)behaviorCriteria.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)behaviorCriteria.durationSeconds(), DURATIONSECONDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

