/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuthorizerDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthorizerDescriptionMarshaller {
    private static final MarshallingInfo<String> AUTHORIZERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerName").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerArn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERFUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerFunctionArn").isBinary(false).build();
    private static final MarshallingInfo<String> TOKENKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenKeyName").isBinary(false).build();
    private static final MarshallingInfo<Map> TOKENSIGNINGPUBLICKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenSigningPublicKeys").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").isBinary(false).build();
    private static final AuthorizerDescriptionMarshaller INSTANCE = new AuthorizerDescriptionMarshaller();

    private AuthorizerDescriptionMarshaller() {
    }

    public static AuthorizerDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthorizerDescription authorizerDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authorizerDescription, (String)"authorizerDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authorizerDescription.authorizerName(), AUTHORIZERNAME_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.authorizerArn(), AUTHORIZERARN_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.authorizerFunctionArn(), AUTHORIZERFUNCTIONARN_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.tokenKeyName(), TOKENKEYNAME_BINDING);
            protocolMarshaller.marshall(authorizerDescription.tokenSigningPublicKeys(), TOKENSIGNINGPUBLICKEYS_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)authorizerDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

