/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuthResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUTHINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authInfo").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ALLOWED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowed").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DENIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denied").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHDECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authDecision").isBinary(false).build();
    private static final MarshallingInfo<List> MISSINGCONTEXTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missingContextValues").isBinary(false).build();
    private static final AuthResultMarshaller INSTANCE = new AuthResultMarshaller();

    private AuthResultMarshaller() {
    }

    public static AuthResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthResult authResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authResult, (String)"authResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authResult.authInfo(), AUTHINFO_BINDING);
            protocolMarshaller.marshall((Object)authResult.allowed(), ALLOWED_BINDING);
            protocolMarshaller.marshall((Object)authResult.denied(), DENIED_BINDING);
            protocolMarshaller.marshall((Object)authResult.authDecisionAsString(), AUTHDECISION_BINDING);
            protocolMarshaller.marshall(authResult.missingContextValues(), MISSINGCONTEXTVALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

