/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AuditNotificationTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuditNotificationTargetMarshaller {
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").isBinary(false).build();
    private static final AuditNotificationTargetMarshaller INSTANCE = new AuditNotificationTargetMarshaller();

    private AuditNotificationTargetMarshaller() {
    }

    public static AuditNotificationTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuditNotificationTarget auditNotificationTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)auditNotificationTarget, (String)"auditNotificationTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)auditNotificationTarget.targetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)auditNotificationTarget.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)auditNotificationTarget.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

