/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuditFinding;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuditFindingMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();
    private static final MarshallingInfo<String> CHECKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("checkName").isBinary(false).build();
    private static final MarshallingInfo<Instant> TASKSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> FINDINGTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingTime").isBinary(false).build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severity").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTRESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantResource").isBinary(false).build();
    private static final MarshallingInfo<List> RELATEDRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedResources").isBinary(false).build();
    private static final MarshallingInfo<String> REASONFORNONCOMPLIANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reasonForNonCompliance").isBinary(false).build();
    private static final MarshallingInfo<String> REASONFORNONCOMPLIANCECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reasonForNonComplianceCode").isBinary(false).build();
    private static final AuditFindingMarshaller INSTANCE = new AuditFindingMarshaller();

    private AuditFindingMarshaller() {
    }

    public static AuditFindingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuditFinding auditFinding, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)auditFinding, (String)"auditFinding");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)auditFinding.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.checkName(), CHECKNAME_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.taskStartTime(), TASKSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.findingTime(), FINDINGTIME_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.severityAsString(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.nonCompliantResource(), NONCOMPLIANTRESOURCE_BINDING);
            protocolMarshaller.marshall(auditFinding.relatedResources(), RELATEDRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.reasonForNonCompliance(), REASONFORNONCOMPLIANCE_BINDING);
            protocolMarshaller.marshall((Object)auditFinding.reasonForNonComplianceCode(), REASONFORNONCOMPLIANCECODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

