/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.AlertTarget;

public class AlertTargetUnmarshaller
implements Unmarshaller<AlertTarget, JsonUnmarshallerContext> {
    private static final AlertTargetUnmarshaller INSTANCE = new AlertTargetUnmarshaller();

    public AlertTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        AlertTarget.Builder alertTargetBuilder = AlertTarget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("alertTargetArn", targetDepth)) {
                    context.nextToken();
                    alertTargetBuilder.alertTargetArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    alertTargetBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AlertTarget)alertTargetBuilder.build();
    }

    public static AlertTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

