/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AlertTargetMarshaller {
    private static final MarshallingInfo<String> ALERTTARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alertTargetArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final AlertTargetMarshaller INSTANCE = new AlertTargetMarshaller();

    private AlertTargetMarshaller() {
    }

    public static AlertTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AlertTarget alertTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)alertTarget, (String)"alertTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)alertTarget.alertTargetArn(), ALERTTARGETARN_BINDING);
            protocolMarshaller.marshall((Object)alertTarget.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

