/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoleAliasRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateRoleAliasRequest> {
    private final String roleAlias;
    private final String roleArn;
    private final Integer credentialDurationSeconds;

    private UpdateRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleArn = builder.roleArn;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
    }

    public String roleAlias() {
        return this.roleAlias;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Integer credentialDurationSeconds() {
        return this.credentialDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialDurationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoleAliasRequest)) {
            return false;
        }
        UpdateRoleAliasRequest other = (UpdateRoleAliasRequest)((Object)obj);
        return Objects.equals(this.roleAlias(), other.roleAlias()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.credentialDurationSeconds(), other.credentialDurationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRoleAliasRequest").add("RoleAlias", (Object)this.roleAlias()).add("RoleArn", (Object)this.roleArn()).add("CredentialDurationSeconds", (Object)this.credentialDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleAlias": {
                return Optional.ofNullable(clazz.cast(this.roleAlias()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "credentialDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.credentialDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleAlias;
        private String roleArn;
        private Integer credentialDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoleAliasRequest model) {
            super(model);
            this.roleAlias(model.roleAlias);
            this.roleArn(model.roleArn);
            this.credentialDurationSeconds(model.credentialDurationSeconds);
        }

        public final String getRoleAlias() {
            return this.roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getCredentialDurationSeconds() {
            return this.credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoleAliasRequest build() {
            return new UpdateRoleAliasRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, UpdateRoleAliasRequest> {
        public Builder roleAlias(String var1);

        public Builder roleArn(String var1);

        public Builder credentialDurationSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

