/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.StreamSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamSummary> {
    private final String streamId;
    private final String streamArn;
    private final Integer streamVersion;
    private final String description;

    private StreamSummary(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.streamVersion = builder.streamVersion;
        this.description = builder.description;
    }

    public String streamId() {
        return this.streamId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public Integer streamVersion() {
        return this.streamVersion;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSummary)) {
            return false;
        }
        StreamSummary other = (StreamSummary)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.streamVersion(), other.streamVersion()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"StreamSummary").add("StreamId", (Object)this.streamId()).add("StreamArn", (Object)this.streamArn()).add("StreamVersion", (Object)this.streamVersion()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "streamVersion": {
                return Optional.ofNullable(clazz.cast(this.streamVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private String streamArn;
        private Integer streamVersion;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSummary model) {
            this.streamId(model.streamId);
            this.streamArn(model.streamArn);
            this.streamVersion(model.streamVersion);
            this.description(model.description);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final Integer getStreamVersion() {
            return this.streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public StreamSummary build() {
            return new StreamSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamSummary> {
        public Builder streamId(String var1);

        public Builder streamArn(String var1);

        public Builder streamVersion(Integer var1);

        public Builder description(String var1);
    }
}

