/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.StreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stream
implements StructuredPojo,
ToCopyableBuilder<Builder, Stream> {
    private final String streamId;
    private final Integer fileId;

    private Stream(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.fileId = builder.fileId;
    }

    public String streamId() {
        return this.streamId;
    }

    public Integer fileId() {
        return this.fileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.fileId(), other.fileId());
    }

    public String toString() {
        return ToString.builder((String)"Stream").add("StreamId", (Object)this.streamId()).add("FileId", (Object)this.fileId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "fileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private Integer fileId;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            this.streamId(model.streamId);
            this.fileId(model.fileId);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final Integer getFileId() {
            return this.fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        public Stream build() {
            return new Stream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Stream> {
        public Builder streamId(String var1);

        public Builder fileId(Integer var1);
    }
}

