/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.StepFunctionsActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepFunctionsAction
implements StructuredPojo,
ToCopyableBuilder<Builder, StepFunctionsAction> {
    private final String executionNamePrefix;
    private final String stateMachineName;
    private final String roleArn;

    private StepFunctionsAction(BuilderImpl builder) {
        this.executionNamePrefix = builder.executionNamePrefix;
        this.stateMachineName = builder.stateMachineName;
        this.roleArn = builder.roleArn;
    }

    public String executionNamePrefix() {
        return this.executionNamePrefix;
    }

    public String stateMachineName() {
        return this.stateMachineName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepFunctionsAction)) {
            return false;
        }
        StepFunctionsAction other = (StepFunctionsAction)obj;
        return Objects.equals(this.executionNamePrefix(), other.executionNamePrefix()) && Objects.equals(this.stateMachineName(), other.stateMachineName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"StepFunctionsAction").add("ExecutionNamePrefix", (Object)this.executionNamePrefix()).add("StateMachineName", (Object)this.stateMachineName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.executionNamePrefix()));
            }
            case "stateMachineName": {
                return Optional.ofNullable(clazz.cast(this.stateMachineName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepFunctionsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionNamePrefix;
        private String stateMachineName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StepFunctionsAction model) {
            this.executionNamePrefix(model.executionNamePrefix);
            this.stateMachineName(model.stateMachineName);
            this.roleArn(model.roleArn);
        }

        public final String getExecutionNamePrefix() {
            return this.executionNamePrefix;
        }

        @Override
        public final Builder executionNamePrefix(String executionNamePrefix) {
            this.executionNamePrefix = executionNamePrefix;
            return this;
        }

        public final void setExecutionNamePrefix(String executionNamePrefix) {
            this.executionNamePrefix = executionNamePrefix;
        }

        public final String getStateMachineName() {
            return this.stateMachineName;
        }

        @Override
        public final Builder stateMachineName(String stateMachineName) {
            this.stateMachineName = stateMachineName;
            return this;
        }

        public final void setStateMachineName(String stateMachineName) {
            this.stateMachineName = stateMachineName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public StepFunctionsAction build() {
            return new StepFunctionsAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepFunctionsAction> {
        public Builder executionNamePrefix(String var1);

        public Builder stateMachineName(String var1);

        public Builder roleArn(String var1);
    }
}

