/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SigningProfileParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningProfileParameter
implements StructuredPojo,
ToCopyableBuilder<Builder, SigningProfileParameter> {
    private final String certificateArn;
    private final String platform;
    private final String certificatePathOnDevice;

    private SigningProfileParameter(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.platform = builder.platform;
        this.certificatePathOnDevice = builder.certificatePathOnDevice;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String platform() {
        return this.platform;
    }

    public String certificatePathOnDevice() {
        return this.certificatePathOnDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePathOnDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfileParameter)) {
            return false;
        }
        SigningProfileParameter other = (SigningProfileParameter)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.certificatePathOnDevice(), other.certificatePathOnDevice());
    }

    public String toString() {
        return ToString.builder((String)"SigningProfileParameter").add("CertificateArn", (Object)this.certificateArn()).add("Platform", (Object)this.platform()).add("CertificatePathOnDevice", (Object)this.certificatePathOnDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "certificatePathOnDevice": {
                return Optional.ofNullable(clazz.cast(this.certificatePathOnDevice()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningProfileParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String platform;
        private String certificatePathOnDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfileParameter model) {
            this.certificateArn(model.certificateArn);
            this.platform(model.platform);
            this.certificatePathOnDevice(model.certificatePathOnDevice);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getCertificatePathOnDevice() {
            return this.certificatePathOnDevice;
        }

        @Override
        public final Builder certificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
            return this;
        }

        public final void setCertificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
        }

        public SigningProfileParameter build() {
            return new SigningProfileParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SigningProfileParameter> {
        public Builder certificateArn(String var1);

        public Builder platform(String var1);

        public Builder certificatePathOnDevice(String var1);
    }
}

