/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;
import software.amazon.awssdk.services.iot.transform.SecurityProfileTargetMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityProfileTargetMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, SecurityProfileTargetMapping> {
    private final SecurityProfileIdentifier securityProfileIdentifier;
    private final SecurityProfileTarget target;

    private SecurityProfileTargetMapping(BuilderImpl builder) {
        this.securityProfileIdentifier = builder.securityProfileIdentifier;
        this.target = builder.target;
    }

    public SecurityProfileIdentifier securityProfileIdentifier() {
        return this.securityProfileIdentifier;
    }

    public SecurityProfileTarget target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileTargetMapping)) {
            return false;
        }
        SecurityProfileTargetMapping other = (SecurityProfileTargetMapping)obj;
        return Objects.equals(this.securityProfileIdentifier(), other.securityProfileIdentifier()) && Objects.equals(this.target(), other.target());
    }

    public String toString() {
        return ToString.builder((String)"SecurityProfileTargetMapping").add("SecurityProfileIdentifier", (Object)this.securityProfileIdentifier()).add("Target", (Object)this.target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIdentifier()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityProfileTargetMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SecurityProfileIdentifier securityProfileIdentifier;
        private SecurityProfileTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileTargetMapping model) {
            this.securityProfileIdentifier(model.securityProfileIdentifier);
            this.target(model.target);
        }

        public final SecurityProfileIdentifier.Builder getSecurityProfileIdentifier() {
            return this.securityProfileIdentifier != null ? this.securityProfileIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder securityProfileIdentifier(SecurityProfileIdentifier securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier;
            return this;
        }

        public final void setSecurityProfileIdentifier(SecurityProfileIdentifier.BuilderImpl securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier != null ? securityProfileIdentifier.build() : null;
        }

        public final SecurityProfileTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(SecurityProfileTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(SecurityProfileTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public SecurityProfileTargetMapping build() {
            return new SecurityProfileTargetMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityProfileTargetMapping> {
        public Builder securityProfileIdentifier(SecurityProfileIdentifier var1);

        default public Builder securityProfileIdentifier(Consumer<SecurityProfileIdentifier.Builder> securityProfileIdentifier) {
            return this.securityProfileIdentifier((SecurityProfileIdentifier)((SecurityProfileIdentifier.Builder)SecurityProfileIdentifier.builder().applyMutation(securityProfileIdentifier)).build());
        }

        public Builder target(SecurityProfileTarget var1);

        default public Builder target(Consumer<SecurityProfileTarget.Builder> target) {
            return this.target((SecurityProfileTarget)((SecurityProfileTarget.Builder)SecurityProfileTarget.builder().applyMutation(target)).build());
        }
    }
}

