/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SecurityProfileIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityProfileIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, SecurityProfileIdentifier> {
    private final String name;
    private final String arn;

    private SecurityProfileIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileIdentifier)) {
            return false;
        }
        SecurityProfileIdentifier other = (SecurityProfileIdentifier)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"SecurityProfileIdentifier").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityProfileIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileIdentifier model) {
            this.name(model.name);
            this.arn(model.arn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public SecurityProfileIdentifier build() {
            return new SecurityProfileIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityProfileIdentifier> {
        public Builder name(String var1);

        public Builder arn(String var1);
    }
}

