/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.S3DestinationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Destination
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Destination> {
    private final String bucket;
    private final String prefix;

    private S3Destination(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix());
    }

    public String toString() {
        return ToString.builder((String)"S3Destination").add("Bucket", (Object)this.bucket()).add("Prefix", (Object)this.prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            this.bucket(model.bucket);
            this.prefix(model.prefix);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public S3Destination build() {
            return new S3Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Destination> {
        public Builder bucket(String var1);

        public Builder prefix(String var1);
    }
}

