/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.RoleAliasDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleAliasDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, RoleAliasDescription> {
    private final String roleAlias;
    private final String roleAliasArn;
    private final String roleArn;
    private final String owner;
    private final Integer credentialDurationSeconds;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private RoleAliasDescription(BuilderImpl builder) {
        this.roleAlias = builder.roleAlias;
        this.roleAliasArn = builder.roleAliasArn;
        this.roleArn = builder.roleArn;
        this.owner = builder.owner;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String roleAlias() {
        return this.roleAlias;
    }

    public String roleAliasArn() {
        return this.roleAliasArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String owner() {
        return this.owner;
    }

    public Integer credentialDurationSeconds() {
        return this.credentialDurationSeconds;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleAliasDescription)) {
            return false;
        }
        RoleAliasDescription other = (RoleAliasDescription)obj;
        return Objects.equals(this.roleAlias(), other.roleAlias()) && Objects.equals(this.roleAliasArn(), other.roleAliasArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.credentialDurationSeconds(), other.credentialDurationSeconds()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"RoleAliasDescription").add("RoleAlias", (Object)this.roleAlias()).add("RoleAliasArn", (Object)this.roleAliasArn()).add("RoleArn", (Object)this.roleArn()).add("Owner", (Object)this.owner()).add("CredentialDurationSeconds", (Object)this.credentialDurationSeconds()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleAlias": {
                return Optional.ofNullable(clazz.cast(this.roleAlias()));
            }
            case "roleAliasArn": {
                return Optional.ofNullable(clazz.cast(this.roleAliasArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "credentialDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.credentialDurationSeconds()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoleAliasDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleAlias;
        private String roleAliasArn;
        private String roleArn;
        private String owner;
        private Integer credentialDurationSeconds;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleAliasDescription model) {
            this.roleAlias(model.roleAlias);
            this.roleAliasArn(model.roleAliasArn);
            this.roleArn(model.roleArn);
            this.owner(model.owner);
            this.credentialDurationSeconds(model.credentialDurationSeconds);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getRoleAlias() {
            return this.roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        public final String getRoleAliasArn() {
            return this.roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Integer getCredentialDurationSeconds() {
            return this.credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public RoleAliasDescription build() {
            return new RoleAliasDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleAliasDescription> {
        public Builder roleAlias(String var1);

        public Builder roleAliasArn(String var1);

        public Builder roleArn(String var1);

        public Builder owner(String var1);

        public Builder credentialDurationSeconds(Integer var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

