/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.RegistrationConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, RegistrationConfig> {
    private final String templateBody;
    private final String roleArn;

    private RegistrationConfig(BuilderImpl builder) {
        this.templateBody = builder.templateBody;
        this.roleArn = builder.roleArn;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationConfig)) {
            return false;
        }
        RegistrationConfig other = (RegistrationConfig)obj;
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"RegistrationConfig").add("TemplateBody", (Object)this.templateBody()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegistrationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateBody;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationConfig model) {
            this.templateBody(model.templateBody);
            this.roleArn(model.roleArn);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public RegistrationConfig build() {
            return new RegistrationConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegistrationConfig> {
        public Builder templateBody(String var1);

        public Builder roleArn(String var1);
    }
}

