/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ResourceArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, RegisterThingResponse> {
    private final String certificatePem;
    private final Map<String, String> resourceArns;

    private RegisterThingResponse(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.resourceArns = builder.resourceArns;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public Map<String, String> resourceArns() {
        return this.resourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterThingResponse)) {
            return false;
        }
        RegisterThingResponse other = (RegisterThingResponse)((Object)obj);
        return Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.resourceArns(), other.resourceArns());
    }

    public String toString() {
        return ToString.builder((String)"RegisterThingResponse").add("CertificatePem", (Object)this.certificatePem()).add("ResourceArns", this.resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificatePem;
        private Map<String, String> resourceArns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterThingResponse model) {
            super(model);
            this.certificatePem(model.certificatePem);
            this.resourceArns(model.resourceArns);
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final Map<String, String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        public final void setResourceArns(Map<String, String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public RegisterThingResponse build() {
            return new RegisterThingResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, RegisterThingResponse> {
        public Builder certificatePem(String var1);

        public Builder resourceArns(Map<String, String> var1);
    }
}

