/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.OTAUpdateSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OTAUpdateSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, OTAUpdateSummary> {
    private final String otaUpdateId;
    private final String otaUpdateArn;
    private final Instant creationDate;

    private OTAUpdateSummary(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
    }

    public String otaUpdateId() {
        return this.otaUpdateId;
    }

    public String otaUpdateArn() {
        return this.otaUpdateArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateSummary)) {
            return false;
        }
        OTAUpdateSummary other = (OTAUpdateSummary)obj;
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"OTAUpdateSummary").add("OtaUpdateId", (Object)this.otaUpdateId()).add("OtaUpdateArn", (Object)this.otaUpdateArn()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "otaUpdateArn": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateArn()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OTAUpdateSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String otaUpdateArn;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateSummary model) {
            this.otaUpdateId(model.otaUpdateId);
            this.otaUpdateArn(model.otaUpdateArn);
            this.creationDate(model.creationDate);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getOtaUpdateArn() {
            return this.otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public OTAUpdateSummary build() {
            return new OTAUpdateSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OTAUpdateSummary> {
        public Builder otaUpdateId(String var1);

        public Builder otaUpdateArn(String var1);

        public Builder creationDate(Instant var1);
    }
}

