/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.services.iot.model.LogTarget;
import software.amazon.awssdk.services.iot.transform.LogTargetConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogTargetConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, LogTargetConfiguration> {
    private final LogTarget logTarget;
    private final String logLevel;

    private LogTargetConfiguration(BuilderImpl builder) {
        this.logTarget = builder.logTarget;
        this.logLevel = builder.logLevel;
    }

    public LogTarget logTarget() {
        return this.logTarget;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogTargetConfiguration)) {
            return false;
        }
        LogTargetConfiguration other = (LogTargetConfiguration)obj;
        return Objects.equals(this.logTarget(), other.logTarget()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"LogTargetConfiguration").add("LogTarget", (Object)this.logTarget()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logTarget": {
                return Optional.ofNullable(clazz.cast(this.logTarget()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogTargetConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private LogTarget logTarget;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(LogTargetConfiguration model) {
            this.logTarget(model.logTarget);
            this.logLevel(model.logLevel);
        }

        public final LogTarget.Builder getLogTarget() {
            return this.logTarget != null ? this.logTarget.toBuilder() : null;
        }

        @Override
        public final Builder logTarget(LogTarget logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public final void setLogTarget(LogTarget.BuilderImpl logTarget) {
            this.logTarget = logTarget != null ? logTarget.build() : null;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public LogTargetConfiguration build() {
            return new LogTargetConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogTargetConfiguration> {
        public Builder logTarget(LogTarget var1);

        default public Builder logTarget(Consumer<LogTarget.Builder> logTarget) {
            return this.logTarget((LogTarget)((LogTarget.Builder)LogTarget.builder().applyMutation(logTarget)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

