/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PrincipalsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingPrincipalsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingPrincipalsResponse> {
    private final List<String> principals;

    private ListThingPrincipalsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
    }

    public List<String> principals() {
        return this.principals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsResponse)) {
            return false;
        }
        ListThingPrincipalsResponse other = (ListThingPrincipalsResponse)((Object)obj);
        return Objects.equals(this.principals(), other.principals());
    }

    public String toString() {
        return ToString.builder((String)"ListThingPrincipalsResponse").add("Principals", this.principals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsResponse model) {
            super(model);
            this.principals(model.principals);
        }

        public final Collection<String> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        @Override
        public ListThingPrincipalsResponse build() {
            return new ListThingPrincipalsResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListThingPrincipalsResponse> {
        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);
    }
}

