/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetsForSecurityProfileResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListTargetsForSecurityProfileResponse> {
    private final List<SecurityProfileTarget> securityProfileTargets;
    private final String nextToken;

    private ListTargetsForSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileTargets = builder.securityProfileTargets;
        this.nextToken = builder.nextToken;
    }

    public List<SecurityProfileTarget> securityProfileTargets() {
        return this.securityProfileTargets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForSecurityProfileResponse)) {
            return false;
        }
        ListTargetsForSecurityProfileResponse other = (ListTargetsForSecurityProfileResponse)((Object)obj);
        return Objects.equals(this.securityProfileTargets(), other.securityProfileTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTargetsForSecurityProfileResponse").add("SecurityProfileTargets", this.securityProfileTargets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileTargets": {
                return Optional.ofNullable(clazz.cast(this.securityProfileTargets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileTarget> securityProfileTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsForSecurityProfileResponse model) {
            super(model);
            this.securityProfileTargets(model.securityProfileTargets);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileTarget.Builder> getSecurityProfileTargets() {
            return this.securityProfileTargets != null ? (Collection)this.securityProfileTargets.stream().map(SecurityProfileTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileTargets(Collection<SecurityProfileTarget> securityProfileTargets) {
            this.securityProfileTargets = SecurityProfileTargetsCopier.copy(securityProfileTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargets(SecurityProfileTarget ... securityProfileTargets) {
            this.securityProfileTargets(Arrays.asList(securityProfileTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargets(Consumer<SecurityProfileTarget.Builder> ... securityProfileTargets) {
            this.securityProfileTargets(Stream.of(securityProfileTargets).map(c -> (SecurityProfileTarget)((SecurityProfileTarget.Builder)SecurityProfileTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileTargets(Collection<SecurityProfileTarget.BuilderImpl> securityProfileTargets) {
            this.securityProfileTargets = SecurityProfileTargetsCopier.copyFromBuilder(securityProfileTargets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTargetsForSecurityProfileResponse build() {
            return new ListTargetsForSecurityProfileResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListTargetsForSecurityProfileResponse> {
        public Builder securityProfileTargets(Collection<SecurityProfileTarget> var1);

        public Builder securityProfileTargets(SecurityProfileTarget ... var1);

        public Builder securityProfileTargets(Consumer<SecurityProfileTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

