/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilesForTargetResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListSecurityProfilesForTargetResponse> {
    private final List<SecurityProfileTargetMapping> securityProfileTargetMappings;
    private final String nextToken;

    private ListSecurityProfilesForTargetResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileTargetMappings = builder.securityProfileTargetMappings;
        this.nextToken = builder.nextToken;
    }

    public List<SecurityProfileTargetMapping> securityProfileTargetMappings() {
        return this.securityProfileTargetMappings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileTargetMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetResponse)) {
            return false;
        }
        ListSecurityProfilesForTargetResponse other = (ListSecurityProfilesForTargetResponse)((Object)obj);
        return Objects.equals(this.securityProfileTargetMappings(), other.securityProfileTargetMappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSecurityProfilesForTargetResponse").add("SecurityProfileTargetMappings", this.securityProfileTargetMappings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileTargetMappings": {
                return Optional.ofNullable(clazz.cast(this.securityProfileTargetMappings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileTargetMapping> securityProfileTargetMappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetResponse model) {
            super(model);
            this.securityProfileTargetMappings(model.securityProfileTargetMappings);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityProfileTargetMapping.Builder> getSecurityProfileTargetMappings() {
            return this.securityProfileTargetMappings != null ? (Collection)this.securityProfileTargetMappings.stream().map(SecurityProfileTargetMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier.copy(securityProfileTargetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(SecurityProfileTargetMapping ... securityProfileTargetMappings) {
            this.securityProfileTargetMappings(Arrays.asList(securityProfileTargetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(Consumer<SecurityProfileTargetMapping.Builder> ... securityProfileTargetMappings) {
            this.securityProfileTargetMappings(Stream.of(securityProfileTargetMappings).map(c -> (SecurityProfileTargetMapping)((SecurityProfileTargetMapping.Builder)SecurityProfileTargetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityProfileTargetMappings(Collection<SecurityProfileTargetMapping.BuilderImpl> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier.copyFromBuilder(securityProfileTargetMappings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecurityProfilesForTargetResponse build() {
            return new ListSecurityProfilesForTargetResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListSecurityProfilesForTargetResponse> {
        public Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> var1);

        public Builder securityProfileTargetMappings(SecurityProfileTargetMapping ... var1);

        public Builder securityProfileTargetMappings(Consumer<SecurityProfileTargetMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

