/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrincipalThingsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListPrincipalThingsResponse> {
    private final List<String> things;
    private final String nextToken;

    private ListPrincipalThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public List<String> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.things());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalThingsResponse)) {
            return false;
        }
        ListPrincipalThingsResponse other = (ListPrincipalThingsResponse)((Object)obj);
        return Objects.equals(this.things(), other.things()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPrincipalThingsResponse").add("Things", this.things()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "things": {
                return Optional.ofNullable(clazz.cast(this.things()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> things = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalThingsResponse model) {
            super(model);
            this.things(model.things);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getThings() {
            return this.things;
        }

        @Override
        public final Builder things(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(String ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        public final void setThings(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPrincipalThingsResponse build() {
            return new ListPrincipalThingsResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, ListPrincipalThingsResponse> {
        public Builder things(Collection<String> var1);

        public Builder things(String ... var1);

        public Builder nextToken(String var1);
    }
}

