/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.JobStatus;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private final String status;
    private final String targetSelection;
    private final Integer maxResults;
    private final String nextToken;
    private final String thingGroupName;
    private final String thingGroupId;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.targetSelection = builder.targetSelection;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public String targetSelectionAsString() {
        return this.targetSelection;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public String thingGroupId() {
        return this.thingGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupId(), other.thingGroupId());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsRequest").add("Status", (Object)this.statusAsString()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupId", (Object)this.thingGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupId": {
                return Optional.ofNullable(clazz.cast(this.thingGroupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String status;
        private String targetSelection;
        private Integer maxResults;
        private String nextToken;
        private String thingGroupName;
        private String thingGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.status(model.status);
            this.targetSelection(model.targetSelection);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupId(model.thingGroupId);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupId() {
            return this.thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder thingGroupName(String var1);

        public Builder thingGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

