/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.JobExecutionSummary;
import software.amazon.awssdk.services.iot.transform.JobExecutionSummaryForThingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummaryForThing
implements StructuredPojo,
ToCopyableBuilder<Builder, JobExecutionSummaryForThing> {
    private final String jobId;
    private final JobExecutionSummary jobExecutionSummary;

    private JobExecutionSummaryForThing(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobExecutionSummary = builder.jobExecutionSummary;
    }

    public String jobId() {
        return this.jobId;
    }

    public JobExecutionSummary jobExecutionSummary() {
        return this.jobExecutionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummaryForThing)) {
            return false;
        }
        JobExecutionSummaryForThing other = (JobExecutionSummaryForThing)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobExecutionSummary(), other.jobExecutionSummary());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSummaryForThing").add("JobId", (Object)this.jobId()).add("JobExecutionSummary", (Object)this.jobExecutionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobExecutionSummaryForThingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private JobExecutionSummary jobExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummaryForThing model) {
            this.jobId(model.jobId);
            this.jobExecutionSummary(model.jobExecutionSummary);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final JobExecutionSummary.Builder getJobExecutionSummary() {
            return this.jobExecutionSummary != null ? this.jobExecutionSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary;
            return this;
        }

        public final void setJobExecutionSummary(JobExecutionSummary.BuilderImpl jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary != null ? jobExecutionSummary.build() : null;
        }

        public JobExecutionSummaryForThing build() {
            return new JobExecutionSummaryForThing(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobExecutionSummaryForThing> {
        public Builder jobId(String var1);

        public Builder jobExecutionSummary(JobExecutionSummary var1);

        default public Builder jobExecutionSummary(Consumer<JobExecutionSummary.Builder> jobExecutionSummary) {
            return this.jobExecutionSummary((JobExecutionSummary)((JobExecutionSummary.Builder)JobExecutionSummary.builder().applyMutation(jobExecutionSummary)).build());
        }
    }
}

