/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.S3Destination;
import software.amazon.awssdk.services.iot.transform.DestinationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements StructuredPojo,
ToCopyableBuilder<Builder, Destination> {
    private final S3Destination s3Destination;

    private Destination(BuilderImpl builder) {
        this.s3Destination = builder.s3Destination;
    }

    public S3Destination s3Destination() {
        return this.s3Destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public String toString() {
        return ToString.builder((String)"Destination").add("S3Destination", (Object)this.s3Destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.s3Destination(model.s3Destination);
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public Destination build() {
            return new Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Destination> {
        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }
    }
}

