/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.JobTargetsCopier;
import software.amazon.awssdk.services.iot.model.PresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private final String jobId;
    private final List<String> targets;
    private final String documentSource;
    private final String document;
    private final String description;
    private final PresignedUrlConfig presignedUrlConfig;
    private final String targetSelection;
    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.targets = builder.targets;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.targetSelection = builder.targetSelection;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
    }

    public String jobId() {
        return this.jobId;
    }

    public List<String> targets() {
        return this.targets;
    }

    public String documentSource() {
        return this.documentSource;
    }

    public String document() {
        return this.document;
    }

    public String description() {
        return this.description;
    }

    public PresignedUrlConfig presignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public String targetSelectionAsString() {
        return this.targetSelection;
    }

    public JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRolloutConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.documentSource(), other.documentSource()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.presignedUrlConfig(), other.presignedUrlConfig()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobRequest").add("JobId", (Object)this.jobId()).add("Targets", this.targets()).add("DocumentSource", (Object)this.documentSource()).add("Document", (Object)this.document()).add("Description", (Object)this.description()).add("PresignedUrlConfig", (Object)this.presignedUrlConfig()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("JobExecutionsRolloutConfig", (Object)this.jobExecutionsRolloutConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "documentSource": {
                return Optional.ofNullable(clazz.cast(this.documentSource()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "presignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlConfig()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "jobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRolloutConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String documentSource;
        private String document;
        private String description;
        private PresignedUrlConfig presignedUrlConfig;
        private String targetSelection;
        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.targets(model.targets);
            this.documentSource(model.documentSource);
            this.document(model.document);
            this.description(model.description);
            this.presignedUrlConfig(model.presignedUrlConfig);
            this.targetSelection(model.targetSelection);
            this.jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Collection<String> getTargets() {
            return this.targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        public final String getDocumentSource() {
            return this.documentSource;
        }

        @Override
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return this.presignedUrlConfig != null ? this.presignedUrlConfig.toBuilder() : null;
        }

        @Override
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder jobId(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder documentSource(String var1);

        public Builder document(String var1);

        public Builder description(String var1);

        public Builder presignedUrlConfig(PresignedUrlConfig var1);

        default public Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return this.presignedUrlConfig((PresignedUrlConfig)((PresignedUrlConfig.Builder)PresignedUrlConfig.builder().applyMutation(presignedUrlConfig)).build());
        }

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig var1);

        default public Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return this.jobExecutionsRolloutConfig((JobExecutionsRolloutConfig)((JobExecutionsRolloutConfig.Builder)JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

