/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditFindingSeverity;
import software.amazon.awssdk.services.iot.model.NonCompliantResource;
import software.amazon.awssdk.services.iot.model.RelatedResource;
import software.amazon.awssdk.services.iot.model.RelatedResourcesCopier;
import software.amazon.awssdk.services.iot.transform.AuditFindingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditFinding
implements StructuredPojo,
ToCopyableBuilder<Builder, AuditFinding> {
    private final String taskId;
    private final String checkName;
    private final Instant taskStartTime;
    private final Instant findingTime;
    private final String severity;
    private final NonCompliantResource nonCompliantResource;
    private final List<RelatedResource> relatedResources;
    private final String reasonForNonCompliance;
    private final String reasonForNonComplianceCode;

    private AuditFinding(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.checkName = builder.checkName;
        this.taskStartTime = builder.taskStartTime;
        this.findingTime = builder.findingTime;
        this.severity = builder.severity;
        this.nonCompliantResource = builder.nonCompliantResource;
        this.relatedResources = builder.relatedResources;
        this.reasonForNonCompliance = builder.reasonForNonCompliance;
        this.reasonForNonComplianceCode = builder.reasonForNonComplianceCode;
    }

    public String taskId() {
        return this.taskId;
    }

    public String checkName() {
        return this.checkName;
    }

    public Instant taskStartTime() {
        return this.taskStartTime;
    }

    public Instant findingTime() {
        return this.findingTime;
    }

    public AuditFindingSeverity severity() {
        return AuditFindingSeverity.fromValue(this.severity);
    }

    public String severityAsString() {
        return this.severity;
    }

    public NonCompliantResource nonCompliantResource() {
        return this.nonCompliantResource;
    }

    public List<RelatedResource> relatedResources() {
        return this.relatedResources;
    }

    public String reasonForNonCompliance() {
        return this.reasonForNonCompliance;
    }

    public String reasonForNonComplianceCode() {
        return this.reasonForNonComplianceCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonForNonCompliance());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonForNonComplianceCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.checkName(), other.checkName()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.findingTime(), other.findingTime()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.nonCompliantResource(), other.nonCompliantResource()) && Objects.equals(this.relatedResources(), other.relatedResources()) && Objects.equals(this.reasonForNonCompliance(), other.reasonForNonCompliance()) && Objects.equals(this.reasonForNonComplianceCode(), other.reasonForNonComplianceCode());
    }

    public String toString() {
        return ToString.builder((String)"AuditFinding").add("TaskId", (Object)this.taskId()).add("CheckName", (Object)this.checkName()).add("TaskStartTime", (Object)this.taskStartTime()).add("FindingTime", (Object)this.findingTime()).add("Severity", (Object)this.severityAsString()).add("NonCompliantResource", (Object)this.nonCompliantResource()).add("RelatedResources", this.relatedResources()).add("ReasonForNonCompliance", (Object)this.reasonForNonCompliance()).add("ReasonForNonComplianceCode", (Object)this.reasonForNonComplianceCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "checkName": {
                return Optional.ofNullable(clazz.cast(this.checkName()));
            }
            case "taskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "findingTime": {
                return Optional.ofNullable(clazz.cast(this.findingTime()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "nonCompliantResource": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResource()));
            }
            case "relatedResources": {
                return Optional.ofNullable(clazz.cast(this.relatedResources()));
            }
            case "reasonForNonCompliance": {
                return Optional.ofNullable(clazz.cast(this.reasonForNonCompliance()));
            }
            case "reasonForNonComplianceCode": {
                return Optional.ofNullable(clazz.cast(this.reasonForNonComplianceCode()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditFindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String checkName;
        private Instant taskStartTime;
        private Instant findingTime;
        private String severity;
        private NonCompliantResource nonCompliantResource;
        private List<RelatedResource> relatedResources = DefaultSdkAutoConstructList.getInstance();
        private String reasonForNonCompliance;
        private String reasonForNonComplianceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditFinding model) {
            this.taskId(model.taskId);
            this.checkName(model.checkName);
            this.taskStartTime(model.taskStartTime);
            this.findingTime(model.findingTime);
            this.severity(model.severity);
            this.nonCompliantResource(model.nonCompliantResource);
            this.relatedResources(model.relatedResources);
            this.reasonForNonCompliance(model.reasonForNonCompliance);
            this.reasonForNonComplianceCode(model.reasonForNonComplianceCode);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getCheckName() {
            return this.checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        public final Instant getFindingTime() {
            return this.findingTime;
        }

        @Override
        public final Builder findingTime(Instant findingTime) {
            this.findingTime = findingTime;
            return this;
        }

        public final void setFindingTime(Instant findingTime) {
            this.findingTime = findingTime;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AuditFindingSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final NonCompliantResource.Builder getNonCompliantResource() {
            return this.nonCompliantResource != null ? this.nonCompliantResource.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantResource(NonCompliantResource nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource;
            return this;
        }

        public final void setNonCompliantResource(NonCompliantResource.BuilderImpl nonCompliantResource) {
            this.nonCompliantResource = nonCompliantResource != null ? nonCompliantResource.build() : null;
        }

        public final Collection<RelatedResource.Builder> getRelatedResources() {
            return this.relatedResources != null ? (Collection)this.relatedResources.stream().map(RelatedResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedResources(Collection<RelatedResource> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(RelatedResource ... relatedResources) {
            this.relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<RelatedResource.Builder> ... relatedResources) {
            this.relatedResources(Stream.of(relatedResources).map(c -> (RelatedResource)((RelatedResource.Builder)RelatedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedResources(Collection<RelatedResource.BuilderImpl> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copyFromBuilder(relatedResources);
        }

        public final String getReasonForNonCompliance() {
            return this.reasonForNonCompliance;
        }

        @Override
        public final Builder reasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
            return this;
        }

        public final void setReasonForNonCompliance(String reasonForNonCompliance) {
            this.reasonForNonCompliance = reasonForNonCompliance;
        }

        public final String getReasonForNonComplianceCode() {
            return this.reasonForNonComplianceCode;
        }

        @Override
        public final Builder reasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
            return this;
        }

        public final void setReasonForNonComplianceCode(String reasonForNonComplianceCode) {
            this.reasonForNonComplianceCode = reasonForNonComplianceCode;
        }

        public AuditFinding build() {
            return new AuditFinding(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuditFinding> {
        public Builder taskId(String var1);

        public Builder checkName(String var1);

        public Builder taskStartTime(Instant var1);

        public Builder findingTime(Instant var1);

        public Builder severity(String var1);

        public Builder severity(AuditFindingSeverity var1);

        public Builder nonCompliantResource(NonCompliantResource var1);

        default public Builder nonCompliantResource(Consumer<NonCompliantResource.Builder> nonCompliantResource) {
            return this.nonCompliantResource((NonCompliantResource)((NonCompliantResource.Builder)NonCompliantResource.builder().applyMutation(nonCompliantResource)).build());
        }

        public Builder relatedResources(Collection<RelatedResource> var1);

        public Builder relatedResources(RelatedResource ... var1);

        public Builder relatedResources(Consumer<RelatedResource.Builder> ... var1);

        public Builder reasonForNonCompliance(String var1);

        public Builder reasonForNonComplianceCode(String var1);
    }
}

