/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.AlertTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlertTarget
implements StructuredPojo,
ToCopyableBuilder<Builder, AlertTarget> {
    private final String alertTargetArn;
    private final String roleArn;

    private AlertTarget(BuilderImpl builder) {
        this.alertTargetArn = builder.alertTargetArn;
        this.roleArn = builder.roleArn;
    }

    public String alertTargetArn() {
        return this.alertTargetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertTarget)) {
            return false;
        }
        AlertTarget other = (AlertTarget)obj;
        return Objects.equals(this.alertTargetArn(), other.alertTargetArn()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"AlertTarget").add("AlertTargetArn", (Object)this.alertTargetArn()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alertTargetArn": {
                return Optional.ofNullable(clazz.cast(this.alertTargetArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlertTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String alertTargetArn;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AlertTarget model) {
            this.alertTargetArn(model.alertTargetArn);
            this.roleArn(model.roleArn);
        }

        public final String getAlertTargetArn() {
            return this.alertTargetArn;
        }

        @Override
        public final Builder alertTargetArn(String alertTargetArn) {
            this.alertTargetArn = alertTargetArn;
            return this;
        }

        public final void setAlertTargetArn(String alertTargetArn) {
            this.alertTargetArn = alertTargetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public AlertTarget build() {
            return new AlertTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlertTarget> {
        public Builder alertTargetArn(String var1);

        public Builder roleArn(String var1);
    }
}

