/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransferCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("certificateId").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETAWSACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("targetAwsAccount").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").isBinary(false).build();
    private static final TransferCertificateRequestModelMarshaller INSTANCE = new TransferCertificateRequestModelMarshaller();

    private TransferCertificateRequestModelMarshaller() {
    }

    public static TransferCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransferCertificateRequest transferCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)transferCertificateRequest), (String)"transferCertificateRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transferCertificateRequest.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)transferCertificateRequest.targetAwsAccount(), TARGETAWSACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)transferCertificateRequest.transferMessage(), TRANSFERMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

