/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CACertificateDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CACertificateDescriptionMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").isBinary(false).build();
    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOREGISTRATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoRegistrationStatus").isBinary(false).build();
    private static final CACertificateDescriptionMarshaller INSTANCE = new CACertificateDescriptionMarshaller();

    private CACertificateDescriptionMarshaller() {
    }

    public static CACertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CACertificateDescription caCertificateDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)caCertificateDescription, (String)"caCertificateDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)caCertificateDescription.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.ownedBy(), OWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.autoRegistrationStatusAsString(), AUTOREGISTRATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

