/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PutItemInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutItemInput
implements StructuredPojo,
ToCopyableBuilder<Builder, PutItemInput> {
    private final String tableName;

    private PutItemInput(BuilderImpl builder) {
        this.tableName = builder.tableName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemInput)) {
            return false;
        }
        PutItemInput other = (PutItemInput)obj;
        return Objects.equals(this.tableName(), other.tableName());
    }

    public String toString() {
        return ToString.builder((String)"PutItemInput").add("TableName", (Object)this.tableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutItemInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemInput model) {
            this.tableName(model.tableName);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public PutItemInput build() {
            return new PutItemInput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutItemInput> {
        public Builder tableName(String var1);
    }
}

