/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TopicRuleListItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TopicRuleListItemMarshaller {
    private static final MarshallingInfo<String> RULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleArn").isBinary(false).build();
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleName").isBinary(false).build();
    private static final MarshallingInfo<String> TOPICPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topicPattern").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RULEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleDisabled").isBinary(false).build();
    private static final TopicRuleListItemMarshaller INSTANCE = new TopicRuleListItemMarshaller();

    private TopicRuleListItemMarshaller() {
    }

    public static TopicRuleListItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicRuleListItem topicRuleListItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)topicRuleListItem, (String)"topicRuleListItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleArn(), RULEARN_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.topicPattern(), TOPICPATTERN_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)topicRuleListItem.ruleDisabled(), RULEDISABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

