/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SqsAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SqsActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> QUEUEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queueUrl").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USEBASE64_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useBase64").isBinary(false).build();
    private static final SqsActionMarshaller INSTANCE = new SqsActionMarshaller();

    private SqsActionMarshaller() {
    }

    public static SqsActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SqsAction sqsAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sqsAction, (String)"sqsAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sqsAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)sqsAction.queueUrl(), QUEUEURL_BINDING);
            protocolMarshaller.marshall((Object)sqsAction.useBase64(), USEBASE64_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

