/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SalesforceAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SalesforceActionMarshaller {
    private static final MarshallingInfo<String> TOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("token").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final SalesforceActionMarshaller INSTANCE = new SalesforceActionMarshaller();

    private SalesforceActionMarshaller() {
    }

    public static SalesforceActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SalesforceAction salesforceAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)salesforceAction, (String)"salesforceAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)salesforceAction.token(), TOKEN_BINDING);
            protocolMarshaller.marshall((Object)salesforceAction.url(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

