/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.Policy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyName").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyArn").isBinary(false).build();
    private static final PolicyMarshaller INSTANCE = new PolicyMarshaller();

    private PolicyMarshaller() {
    }

    public static PolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Policy policy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policy, (String)"policy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policy.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)policy.policyArn(), POLICYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

