/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.KinesisAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").isBinary(false).build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partitionKey").isBinary(false).build();
    private static final KinesisActionMarshaller INSTANCE = new KinesisActionMarshaller();

    private KinesisActionMarshaller() {
    }

    public static KinesisActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisAction kinesisAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisAction, (String)"kinesisAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisAction.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)kinesisAction.partitionKey(), PARTITIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

