/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;
import software.amazon.awssdk.services.iot.transform.PutItemInputUnmarshaller;

public class DynamoDBv2ActionUnmarshaller
implements Unmarshaller<DynamoDBv2Action, JsonUnmarshallerContext> {
    private static final DynamoDBv2ActionUnmarshaller INSTANCE = new DynamoDBv2ActionUnmarshaller();

    public DynamoDBv2Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDBv2Action.Builder dynamoDBv2ActionBuilder = DynamoDBv2Action.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    dynamoDBv2ActionBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("putItem", targetDepth)) {
                    context.nextToken();
                    dynamoDBv2ActionBuilder.putItem(PutItemInputUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DynamoDBv2Action)dynamoDBv2ActionBuilder.build();
    }

    public static DynamoDBv2ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

