/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CannedAccessControlList;
import software.amazon.awssdk.services.iot.transform.S3ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Action
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Action> {
    private final String roleArn;
    private final String bucketName;
    private final String key;
    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String key() {
        return this.key;
    }

    public CannedAccessControlList cannedAcl() {
        return CannedAccessControlList.fromValue(this.cannedAcl);
    }

    public String cannedAclAsString() {
        return this.cannedAcl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAclAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.cannedAclAsString(), other.cannedAclAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3Action").add("RoleArn", (Object)this.roleArn()).add("BucketName", (Object)this.bucketName()).add("Key", (Object)this.key()).add("CannedAcl", (Object)this.cannedAclAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "bucketName": {
                return Optional.of(clazz.cast(this.bucketName()));
            }
            case "key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "cannedAcl": {
                return Optional.of(clazz.cast(this.cannedAclAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String bucketName;
        private String key;
        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.roleArn(model.roleArn);
            this.bucketName(model.bucketName);
            this.key(model.key);
            this.cannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getCannedAcl() {
            return this.cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
            return this;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        public S3Action build() {
            return new S3Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Action> {
        public Builder roleArn(String var1);

        public Builder bucketName(String var1);

        public Builder key(String var1);

        public Builder cannedAcl(String var1);

        public Builder cannedAcl(CannedAccessControlList var1);
    }
}

