/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.services.iot.model.IoTException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceAlreadyExistsException
extends IoTException
implements ToCopyableBuilder<Builder, ResourceAlreadyExistsException> {
    private final String resourceId;
    private final String resourceArn;

    private ResourceAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceArn;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAlreadyExistsException model) {
            this.resourceId(model.resourceId);
            this.resourceArn(model.resourceArn);
            this.message = model.getMessage();
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @JsonProperty(value="resourceId")
        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @JsonProperty(value="resourceArn")
        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public ResourceAlreadyExistsException build() {
            return new ResourceAlreadyExistsException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceAlreadyExistsException> {
        public Builder resourceId(String var1);

        public Builder resourceArn(String var1);

        public Builder message(String var1);
    }
}

