/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;
import software.amazon.awssdk.services.iot.model.OutgoingCertificatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOutgoingCertificatesResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
    private final List<OutgoingCertificate> outgoingCertificates;
    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<OutgoingCertificate> outgoingCertificates() {
        return this.outgoingCertificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse)((Object)obj);
        return Objects.equals(this.outgoingCertificates(), other.outgoingCertificates()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListOutgoingCertificatesResponse").add("OutgoingCertificates", this.outgoingCertificates()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outgoingCertificates": {
                return Optional.of(clazz.cast(this.outgoingCertificates()));
            }
            case "nextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private List<OutgoingCertificate> outgoingCertificates;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            super(model);
            this.outgoingCertificates(model.outgoingCertificates);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<OutgoingCertificate.Builder> getOutgoingCertificates() {
            return this.outgoingCertificates != null ? (Collection)this.outgoingCertificates.stream().map(OutgoingCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate ... outgoingCertificates) {
            this.outgoingCertificates(Arrays.asList(outgoingCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder> ... outgoingCertificates) {
            this.outgoingCertificates(Stream.of(outgoingCertificates).map(c -> (OutgoingCertificate)((OutgoingCertificate.Builder)OutgoingCertificate.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate.BuilderImpl> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copyFromBuilder(outgoingCertificates);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        public Builder outgoingCertificates(Collection<OutgoingCertificate> var1);

        public Builder outgoingCertificates(OutgoingCertificate ... var1);

        public Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

