/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLoggingOptionsResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, GetLoggingOptionsResponse> {
    private final String roleArn;
    private final String logLevel;

    private GetLoggingOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.logLevel = builder.logLevel;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoggingOptionsResponse)) {
            return false;
        }
        GetLoggingOptionsResponse other = (GetLoggingOptionsResponse)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetLoggingOptionsResponse").add("RoleArn", (Object)this.roleArn()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "logLevel": {
                return Optional.of(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private String roleArn;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoggingOptionsResponse model) {
            super(model);
            this.roleArn(model.roleArn);
            this.logLevel(model.logLevel);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public GetLoggingOptionsResponse build() {
            return new GetLoggingOptionsResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, GetLoggingOptionsResponse> {
        public Builder roleArn(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

