/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachPrincipalPolicyRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, DetachPrincipalPolicyRequest> {
    private final String policyName;
    private final String principal;

    private DetachPrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.principal = builder.principal;
    }

    public String policyName() {
        return this.policyName;
    }

    public String principal() {
        return this.principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachPrincipalPolicyRequest)) {
            return false;
        }
        DetachPrincipalPolicyRequest other = (DetachPrincipalPolicyRequest)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.principal(), other.principal());
    }

    public String toString() {
        return ToString.builder((String)"DetachPrincipalPolicyRequest").add("PolicyName", (Object)this.policyName()).add("Principal", (Object)this.principal()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "principal": {
                return Optional.of(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String policyName;
        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachPrincipalPolicyRequest model) {
            super(model);
            this.policyName(model.policyName);
            this.principal(model.principal);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetachPrincipalPolicyRequest build() {
            return new DetachPrincipalPolicyRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, DetachPrincipalPolicyRequest> {
        public Builder policyName(String var1);

        public Builder principal(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

